<?php
// /home/payiconi/public_html/auth/session_config.php

// Only start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    // Set custom session path
    $sessionPath = __DIR__ . '/sessions';
    
    // Ensure directory exists
    if (!is_dir($sessionPath)) {
        mkdir($sessionPath, 0755, true);
    }
    
    // Set session configuration
    ini_set('session.save_path', $sessionPath);
    ini_set('session.cookie_httponly', 1);
    ini_set('session.use_only_cookies', 1);
    
    // Start session
    session_start();
}
?>